/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin.store;

import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.gcube.data.speciesplugin.store.SpeciesNeoDBProvider;
import org.gcube.data.speciesplugin.store.SpeciesStore;
import org.gcube.data.speciesplugin.utils.SpeciesService;
import org.gcube.data.streams.Stream;
import org.gcube.data.tmf.api.exceptions.InvalidTreeException;
import org.gcube.data.tmf.api.exceptions.UnknownTreeException;
import org.gcube.data.tr.neo.NeoConstants;
import org.gcube.data.tr.neo.NeoDBProvider;
import org.gcube.data.tr.neo.NeoStore;
import org.gcube.data.tr.neo.nodes.BindingMode;
import org.gcube.data.tr.neo.nodes.PersistentNode;
import org.gcube.data.tr.neo.nodes.PersistentTree;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.patterns.Pattern;
import org.neo4j.graphdb.index.ReadableIndex;

public class SpeciesNeoStore
implements SpeciesStore,
Serializable {
    private static final long serialVersionUID = -3997578013033741026L;
    protected static final QName STORE_ID = new QName("storeId");
    protected NeoStore neoStore;

    public SpeciesNeoStore(String storeId) throws IllegalStateException {
        this.neoStore = new NeoStore((NeoDBProvider)new SpeciesNeoDBProvider(), storeId);
    }

    @Override
    public String id() {
        return this.neoStore.id();
    }

    @Override
    public File location() {
        return this.neoStore.location();
    }

    @Override
    public long cardinality() {
        return this.neoStore.cardinality();
    }

    @Override
    public void start(File storageLocation) {
        this.neoStore.start(storageLocation);
    }

    @Override
    public void stop() {
        this.neoStore.stop();
    }

    @Override
    public void delete() {
        this.neoStore.delete();
    }

    @Override
    public Tree get(String id, Pattern pattern) throws UnknownTreeException, InvalidTreeException {
        ReadableIndex autoIndex = this.neoStore.dbservice().index().getNodeAutoIndexer().getAutoIndex();
        org.neo4j.graphdb.Node node = (org.neo4j.graphdb.Node)autoIndex.get(NeoConstants.toAttribute((QName)SpeciesService.SPECIES_SERVICE_ID), (Object)id).getSingle();
        if (node == null) {
            throw new InvalidTreeException("tree with id " + id + " does not exists");
        }
        PersistentNode root = new PersistentNode(this.neoStore.dbservice(), node, BindingMode.READ);
        try {
            pattern.prune((Node)root);
        }
        catch (Exception e) {
            throw new InvalidTreeException("tree " + id + " does not match " + pattern);
        }
        PersistentTree storeTree = new PersistentTree(root);
        Tree serviceTree = this.fromStoreToService((Tree)storeTree);
        return serviceTree;
    }

    @Override
    public Iterator<Tree> get(Pattern pattern) {
        final Iterator iterator = this.neoStore.get(pattern);
        return new Iterator<Tree>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Tree next() {
                Tree serviceTree = SpeciesNeoStore.this.fromStoreToService((Tree)iterator.next());
                return serviceTree;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public Tree add(Tree tree) throws InvalidTreeException {
        return this.neoStore.add(tree);
    }

    @Override
    public Stream<Tree> add(Stream<Tree> treeStream) throws Exception {
        return this.neoStore.add(treeStream);
    }

    protected Tree fromStoreToService(Tree storeTree) {
        String storeId = storeTree.id();
        String serviceId = storeTree.attribute(SpeciesService.SPECIES_SERVICE_ID);
        Tree serviceTree = this.cloneTree(storeTree, serviceId);
        serviceTree.setAttribute(STORE_ID, storeId);
        return serviceTree;
    }

    protected Tree cloneTree(Tree tree, String newId) {
        Tree clone = new Tree(newId, tree.attributes(), tree.edges().toArray(new Edge[tree.edges().size()]));
        clone.setSourceId(tree.sourceId());
        return clone;
    }
}

