package org.gcube.data.streams.generators;

import org.gcube.data.streams.Stream;
import org.gcube.data.streams.exceptions.StreamContingencyException;
import org.gcube.data.streams.exceptions.StreamSkipException;

/**
 * A {@link Filter} that changes the elements of the input {@link Stream}.
 * 
 * @author Fabio Simeoni
 *
 * @param <E> the type of input elements
 */
public abstract class Processor<E> extends Filter<E,E>  {

	@Override
	public final E yield(E element) throws StreamSkipException ,org.gcube.data.streams.exceptions.StreamContingencyException {
		
		process(element);
		return element;
	};
	
	/**
	 * Processes an element of a {@link Stream}.
	 * 
	 * @param element the input element
	 * @throws StreamSkipException if no element should be yielded from the input element
	 * @throws StreamContingencyException if no element can be yielded, because the input element violates pre-conditions
	 * @throws RuntimeException if no element can be yielded from the input element, becuase of an unrecoverable condition
	 */
	protected abstract void process(E element) throws StreamSkipException ,org.gcube.data.streams.exceptions.StreamContingencyException;
}
