package org.gcube.data.streams.publishers;

import org.gcube.data.streams.Stream;
import org.gcube.data.streams.exceptions.StreamContingencyException;

import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;

/**
 * Generates {@link Record}s from the elements of a {@link Stream}.
 * 
 * @author Fabio Simeoni
 *
 * @param <E> the type of the elements
 */
public interface RecordFactory<E> {

	/**
	 * Returns the definitions of the records.
	 * @return the definitions
	 */
	RecordDefinition[] definitions();
	
	/**
	 * Generates a {@link Record} from a {@link Stream} element.
	 * @param element the element
	 * @return the record
	 * @throws StreamContingencyException if no record can be generated, because the input element violates pre-conditions
	 * @throws RuntimeException if no record can be generated, because of an unrecoverable condition
	 */
	Record newRecord(E element) throws StreamContingencyException,RuntimeException;
}
