/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.delegates;

import java.net.URI;
import org.gcube.data.streams.LookAheadStream;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.generators.Generator;

public class UnfoldedStream<E1, E2>
extends LookAheadStream<E2> {
    private final Stream<E1> stream;
    private final Generator<E1, Stream<E2>> generator;
    private Stream<E2> unfold;
    private RuntimeException lookAheadFailure;

    public UnfoldedStream(Stream<E1> stream, Generator<E1, Stream<E2>> generator) throws IllegalArgumentException {
        if (stream == null) {
            throw new IllegalArgumentException("invalid null stream");
        }
        if (generator == null) {
            throw new IllegalArgumentException("invalid null generator");
        }
        this.stream = stream;
        this.generator = generator;
    }

    @Override
    protected E2 delegateNext() {
        return this.lookAheadFailureOrNextInUnfold();
    }

    @Override
    protected boolean delegateHasNext() {
        if (!this.hasUnfold()) {
            return false;
        }
        return this.existsInThisOrNextUnfold();
    }

    @Override
    public void close() {
        if (this.unfold != null) {
            this.unfold.close();
        }
        this.stream.close();
    }

    @Override
    public URI locator() throws IllegalStateException {
        return this.stream.locator();
    }

    private boolean hasUnfold() {
        if (this.unfold == null) {
            if (this.stream.hasNext()) {
                try {
                    this.unfold = this.generator.yield(this.stream.next());
                }
                catch (RuntimeException failure) {
                    this.lookAheadFailure = failure;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean existsInThisOrNextUnfold() {
        boolean hasNext = this.unfold.hasNext();
        if (!hasNext) {
            this.unfold.close();
            this.unfold = null;
            return this.delegateHasNext();
        }
        return hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E2 lookAheadFailureOrNextInUnfold() {
        try {
            if (this.lookAheadFailure != null) {
                throw this.lookAheadFailure;
            }
            E2 E2 = this.unfold.next();
            return E2;
        }
        finally {
            this.lookAheadFailure = null;
        }
    }

    @Override
    public void remove() {
        this.stream.remove();
    }
}

