package org.gcube.data.streams.delegates;

import org.gcube.data.streams.LookAheadStream;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.generators.Generator;

/**
 * A {@link Stream} of elements generated by the elements of an input {@link Stream}
 * 
 * @author Fabio Simeoni
 *
 * @param <E1> the type of elements of the input stream
 * @param <E2> the type of stream elements
 */
public class PipedStream<E1,E2> extends LookAheadStream<E2> {

	private final Stream<E1> stream;
	private final Generator<E1, E2> generator;
	
	/**
	 * Creates an instance with a {@link Stream} and an element {@link Generator}.
	 * @param stream the stream
	 * @param generator the generator
	 * @throws IllegalArgumentException if the stream or the generator are <code>null</code>
	 */
	public PipedStream(Stream<E1> stream,Generator<E1, E2> generator) throws IllegalArgumentException {
		
		if (stream==null)
			throw new IllegalArgumentException("invalid null stream");
		
		if (generator == null)
			throw new IllegalArgumentException("invalid null generator");
		
		this.stream=stream;
		this.generator=generator;
	}
	
	@Override
	protected E2 delegateNext() {
		return generator.yield(stream.next());
	}
	
	@Override
	protected boolean delegateHasNext() {
		return stream.hasNext();
	}
	
	@Override
	public void close() {
		stream.close();
	}
	
	@Override
	public java.net.URI locator() throws IllegalStateException {
		return stream.locator();
	};
	
	@Override
	public void remove() {
		stream.remove();
	}
}
