/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.delegates;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.AbstractDelegateStream;

public class FoldedStream<E>
extends AbstractDelegateStream<E, List<E>> {
    private final int foldSize;

    public FoldedStream(Stream<E> stream, int foldSize) throws IllegalArgumentException {
        super(stream);
        if (foldSize < 1) {
            throw new IllegalArgumentException("invalid foldsize is not positive");
        }
        this.foldSize = foldSize;
    }

    @Override
    protected List<E> delegateNext() {
        ArrayList fold = new ArrayList();
        int i = 0;
        while (i < this.foldSize) {
            if (this.stream().hasNext()) {
                fold.add(this.stream().next());
            }
            ++i;
        }
        return fold;
    }

    @Override
    protected boolean delegateHasNext() {
        return this.stream().hasNext();
    }
}

