/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.adapters;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GRS2ExceptionWrapper;
import gr.uoa.di.madgik.grs.record.Record;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.gcube.data.streams.LookAheadStream;
import org.gcube.data.streams.exceptions.StreamException;
import org.gcube.data.streams.exceptions.StreamOpenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultsetStream<E extends Record>
extends LookAheadStream<E> {
    private static Logger log = LoggerFactory.getLogger(ResultsetStream.class);
    public static final int default_timeout = 30;
    public static final TimeUnit default_timeout_unit = TimeUnit.SECONDS;
    private final URI locator;
    private long timeout = 30L;
    private TimeUnit timeoutUnit = default_timeout_unit;
    private boolean open = false;
    private boolean closed = false;
    private RuntimeException lookAheadFailure;
    private ForwardReader<E> reader;
    private E record;

    public ResultsetStream(URI locator) throws IllegalArgumentException {
        if (locator == null) {
            throw new IllegalArgumentException("invalid or null locator");
        }
        this.locator = locator;
    }

    public void setTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        if (timeout <= 0L || this.timeoutUnit == null) {
            throw new IllegalArgumentException("invalid timeout or null timeout unit");
        }
        this.timeout = timeout;
        this.timeoutUnit = unit;
    }

    @Override
    protected E delegateNext() {
        try {
            if (this.lookAheadFailure != null) {
                throw this.lookAheadFailure;
            }
            if (this.record instanceof GRS2ExceptionWrapper) {
                Throwable cause = ((GRS2ExceptionWrapper)this.record).getEx().getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new StreamException(cause);
            }
            E e = this.record;
            return e;
        }
        finally {
            this.lookAheadFailure = null;
        }
    }

    @Override
    protected boolean delegateHasNext() {
        if (this.closed) {
            return false;
        }
        if (!this.open) {
            try {
                this.reader = new ForwardReader(this.locator);
            }
            catch (Throwable t) {
                this.lookAheadFailure = new StreamOpenException("cannot open resultset " + this.locator, t);
                return true;
            }
            log.info("initialised resultset at " + this.locator);
            this.open = true;
        }
        try {
            this.record = this.reader.get(this.timeout, this.timeoutUnit);
        }
        catch (GRS2ReaderException e) {
            this.lookAheadFailure = new RuntimeException(e);
        }
        if (this.reader.getStatus() != IBuffer.Status.Close && this.record == null) {
            if (this.reader.getStatus() == IBuffer.Status.Open) {
                this.lookAheadFailure = new RuntimeException("Timeout occurred reading the resultSet");
            } else if (this.reader.getStatus() == IBuffer.Status.Dispose) {
                this.lookAheadFailure = new RuntimeException("ResultSet disposed");
            }
            return false;
        }
        return this.record != null;
    }

    @Override
    public void close() {
        if (this.open) {
            try {
                this.reader.close();
                log.info("closed resultset at " + this.locator);
            }
            catch (GRS2ReaderException e) {
                log.error("could not close resultset", (Throwable)e);
            }
            this.open = false;
        }
        this.closed = true;
    }

    @Override
    public URI locator() throws IllegalStateException {
        if (this.open) {
            throw new IllegalStateException("locator is invalid as result set has already been opened");
        }
        return this.locator;
    }

    @Override
    public void remove() {
        this.record = null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

