/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.delegates;

import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.AbstractDelegateStream;
import org.gcube.data.streams.delegates.StreamListener;

public class MonitoredStream<E>
extends AbstractDelegateStream<E, E> {
    private final StreamListener listener;
    private boolean started = false;

    public MonitoredStream(Stream<E> stream, StreamListener listener) throws IllegalArgumentException {
        super(stream);
        if (listener == null) {
            throw new IllegalArgumentException("invalid null listener");
        }
        this.listener = listener;
    }

    @Override
    protected E delegateNext() {
        Object element = this.stream().next();
        if (!this.started) {
            this.listener.onStart();
            this.started = true;
        }
        if (!this.delegateHasNext()) {
            this.listener.onEnd();
        }
        return (E)element;
    }

    @Override
    protected boolean delegateHasNext() {
        return this.stream().hasNext();
    }

    @Override
    public void close() {
        super.close();
        this.listener.onClose();
    }
}

