/**
 * 
 */
package org.gcube.data.tml.exceptions;

import org.gcube.common.clients.Unrecoverable;


/**
 * Raised when identifiers do not identify trees.
 * 
 * @author Fabio Simeoni
 *
 */
@Unrecoverable
public class UnknownTreeException extends Exception {

	private static final long serialVersionUID = 1L;
	
	/**
	 * Creates an instance.
	 */
	public UnknownTreeException(){}
	
	/**
	 * Creates an instance with given message.
	 * @param msg the message
	 */
	public UnknownTreeException(String msg) {
		super(msg);
	}
	
	/**
	 * Creates an instance with a given message and cause.
	 * @param msg the message
	 * @param cause the cause
	 */
	public UnknownTreeException(String msg,Throwable cause) {
		super(msg,cause);
	}
}
