/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.clients.queries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.clients.gcore.GcoreServiceProvider;
import org.gcube.common.clients.gcore.StatefulQuery;
import org.gcube.data.tml.clients.providers.TBinderProvider;
import org.gcube.data.tml.clients.queries.QueryBuilder;

public class BinderQueryBuilder {
    private static final String basePluginCondition = "some $plugin in $result/child::*[local-name()='Plugin'] satisfies (%1$s)";
    private static final String pluginCondition = "$plugin/child::*[local-name()='%1$s'] eq '%2$s'";
    private static final String pluginPropertyCondition = "some $prop in $plugin/child::*[local-name()='Property'] satisfies (%1$s)";
    private static final String propertyCondition = "$prop/child::*[local-name()='%1$s'] eq '%2$s'";
    private String pluginName;
    private Map<String, String> properties = new HashMap<String, String>();

    protected BinderQueryBuilder() {
    }

    public StatefulQuery build() {
        StatefulQuery query = new StatefulQuery((GcoreServiceProvider)TBinderProvider.INSTANCE);
        String condition = this.toString();
        if (!condition.isEmpty()) {
            query.query().addGenericCondition(condition);
        }
        return query;
    }

    public BinderQueryBuilder withPlugin(String name) {
        this.pluginName = name;
        return this;
    }

    public BinderQueryBuilder withProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String toString() {
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.pluginName != null) {
            conditions.add(String.format(pluginCondition, "name", this.pluginName));
        }
        if (!this.properties.isEmpty()) {
            ArrayList<String> propConditions = new ArrayList<String>();
            for (Map.Entry<String, String> prop : this.properties.entrySet()) {
                propConditions.add(String.format(propertyCondition, prop.getKey(), prop.getValue()));
            }
            conditions.add(String.format(pluginPropertyCondition, QueryBuilder.concatenate(propConditions)));
        }
        return conditions.isEmpty() ? "" : String.format(basePluginCondition, QueryBuilder.concatenate(conditions));
    }
}

