package org.gcube.data.tml.clients.providers;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.data.tm.stubs.TWriterPortType;
import org.gcube.data.tm.stubs.service.TWriterServiceAddressingLocator;
import org.gcube.data.tml.Constants;

public class TWriterProvider extends AbstractProvider<TWriterPortType> {

	public static final TWriterProvider INSTANCE = new TWriterProvider();
	
	@Override
	public String name() {
		return Constants.TWRITER_NAME;
	}

	@Override
	public TWriterPortType service(EndpointReferenceType endpoint) {
		try {
			TWriterPortType pt = new TWriterServiceAddressingLocator().getTWriterPortTypePort(endpoint);
			pt = GCUBERemotePortTypeContext.getProxy(pt,GCUBEScopeManager.DEFAULT);
			return pt;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}
