package org.gcube.data.tml.clients.queries;

import java.util.Collection;

import org.gcube.data.tml.clients.providers.TReaderProvider;
import org.gcube.data.tml.clients.providers.TWriterProvider;

public class QueryBuilder {

	/**
	 * Returns a query builder.
	 * @return the builder
	 */
	public static BinderQueryBuilder findBinder() {
		
		return new BinderQueryBuilder();
	}
	
	/**
	 * Returns a builder of queries of services that give read access to data sources.
	 * @return the builder.
	 */
	public static SourceQueryBuilder findReadSource() {
		
		return new SourceQueryBuilder(TReaderProvider.INSTANCE);
	}
	
	/**
	 * Returns a builder of queries of services that give write access to data sources.
	 * @return the builder.
	 */
	public static SourceQueryBuilder findWriteSource() {
		
		return new SourceQueryBuilder(TWriterProvider.INSTANCE);
	}
	
	//helper
	protected static String concatenate(Collection<String> conditions) {
		
		StringBuilder builder = new StringBuilder(); 
		
		for (String condition : conditions)
			if (builder.length()==0)
				builder.append(condition);
			else
				builder.append(" and "+condition);
			
		return builder.toString();	
	}
}
