package org.gcube.data.tml.exceptions;

import org.gcube.common.clients.Unrecoverable;

/**
 * Raised with malformed requests to services.
 * 
 * @author Fabio Simeoni
 *
 */
@Unrecoverable
public class InvalidRequestException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	/**
	 * Creates an instance.
	 */
	public InvalidRequestException() {}
	
	/**
	 * Creates an instance with a message.
	 * @param msg the message
	 */
	public InvalidRequestException(String msg) {
		super(msg);
	}
	
	/**
	 * Creates an instance with a message and a cause.
	 * @param msg the message
	 * @param cause the cause
	 */
	public InvalidRequestException(String msg, Throwable cause) {
		super(msg,cause);
	}
	
	/**
	 * Creates an instance with a cause.
	 * @param cause the cause
	 */
	public InvalidRequestException(Throwable cause) {
		super(cause);
	}
}
