package org.gcube.data.tml.outcomes;

import org.gcube.data.trees.data.Tree;

/**
 * A record of a failed {@link Tree} update.
 * 
 * @author Fabio Simeoni
 *
 */
public class UpdateTreeFailure {

	private String identifier;
	private Exception failure;
	
	/**
	 * Creates an instance with the identifier of a {@link Tree} and an {@link Exception} raised in the attempt to update it.
	 * @param identifier the identifier
	 * @param failure the exception
	 */
	public UpdateTreeFailure(String identifier,Exception failure) {
		this.failure=failure;
		this.identifier=identifier;
	}
	
	/**
	 * Returns the identifier of the tree that could not be updated.
	 * @return the identifier
	 */
	public String identifier() {
		return identifier;
	}
	
	/**
	 * Returns the exception raised when updating the tree.
	 * @return the exception
	 */
	public Exception failure() {
		return failure;
	}
}
