/**
 * 
 */
package org.gcube.data.tml.uri.tm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;

import org.gcube.data.tml.clients.ReaderClient;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.Bindings;

/**
 * 
 * Invoked by the platform with a URL of the right protocol.
 * @author Fabio Simeoni
 *
 */
public class CMSURLConnection extends URLConnection {

	Node node;
	
	/**
	 * Constructs a new instance for a given <code>cms</code> URL.
	 * @param url the URL.
	 */
	public CMSURLConnection(URL url) {
		super(url);
	}

	/**{@inheritDoc}*/
	@Override public synchronized void connect() throws IOException {
		
		try {
			node = ReaderClient.resolve(url.toURI());
			connected=true;
		}
		catch (Exception e) {
			IOException ioe = new IOException();
			ioe.initCause(e);
			throw ioe;
		}
		
	}
	
	/**{@inheritDoc}*/
	@Override public synchronized InputStream getInputStream() throws IOException {
		if (!connected) 
			this.connect(); 
		try {
			StringWriter w = new StringWriter();
			if (node instanceof Tree)
				Bindings.toWriter((Tree)node,w);
			else 
				Bindings.nodeToWriter(node,w);
			return new ByteArrayInputStream(w.toString().getBytes("UTF-8"));
		}
		catch(Exception e) {
			IOException ioe = new IOException();
			ioe.initCause(e);
			throw ioe;
		}			
	}
	

}
