/**
 * 
 */
package org.gcube.data.tml.utils;

import static org.gcube.data.trees.patterns.Patterns.*;

import java.io.PrintWriter;
import java.io.StringWriter;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.axis.message.MessageElement;
import org.gcube.common.core.faults.ExceptionProxy;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.data.tm.stubs.AnyHolder;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.Bindings;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * 
 * Data type conversion utilities
 * 
 * @author Fabio Simeoni
 *
 */
public class Utils {

	private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

	/**
	 * Converts a {@link Pattern} into an {@link AnyHolder} accepted by the service.
	 * @param p the pattern
	 * @return the holder
	 * @throws Exception if the conversion fails
	 */
	public static AnyHolder toHolder(Pattern p) throws Exception {
		
		if (p==null) 
			return null;
		
		Document filterNode = factory.newDocumentBuilder().newDocument();
		Patterns.getMarshaller().marshal(p, filterNode);
		return toHolder(filterNode.getDocumentElement());
		
	}
	
	/**
	 * Converts a {@link AnyHolder} returned by the service into a {@link Pattern}.
	 * @param h the holder
	 * @return the pattern
	 * @throws Exception if the conversion fails
	 */
	public static Pattern getPattern(AnyHolder h) throws Exception {
		
		return h==null?null: (Pattern) getUnMarshaller().unmarshal(h.get_any()[0].getAsDOM());
		
	}
	
	/**
	 * Transforms a {@link Tree} into a {@link AnyHolder} accepted by the service.
	 * @param t the tree
	 * @return the holder
	 * @throws Exception if the conversion fails
	 */
	public static AnyHolder toHolder(Tree t) throws Exception {
		
		return t==null?null:toHolder(Bindings.toElement(t));
		
	}
	
	/**
	 * Converts an {@link Element} into a {@link AnyHolder} accepted by the service.
	 * @param e the element
	 * @return the holder
	 */
	public static AnyHolder toHolder(Element e) {
		
		return e==null?null:new AnyHolder(new MessageElement[]{new MessageElement(e)});
		
	}
	
	/**
	 * Transforms a {@link Node} into a {@link AnyHolder} accepted by the service.
	 * @param n the node
	 * @return the holder
	 * @throws Exception if the conversion fails
	 */
	public static AnyHolder toHolder(Node n) throws Exception {
		
		return n==null?null:toHolder(Bindings.nodeToElement(n));
		
	}
	
	
	/**
	 * Converts an {@link AnyHolder} into an {@link Element}.
	 * @param d the holder
	 * @return the element
	 */
	public static Element toElement(AnyHolder d) {
		return d==null?null: d.get_any()[0];
	}
	
	/**
	 * Converts an {@link AnyHolder} into an {@link Element}.
	 * @param h the holder
	 * @return the element
	 * @throws Exception if the conversion fails
	 */
	public static Tree toTree(AnyHolder h) throws Exception {
		return Bindings.fromElement(toElement(h));
	}
	
	/**
	 * Returns a given fault after serialising into it an original cause.
	 * @param fault the fault
	 * @param cause the cause
	 * @return the fault
	 * @param <E> the type of the fault
	 */
	public static <E extends GCUBEFault> E newFault(E fault, Throwable cause) {
		
		fault.setFaultMessage(cause.getMessage());
		
		//pretty pointless output
		fault.removeFaultDetail(new QName("http://xml.apache.org/axis/","stackTrace"));
		
		//adds whole stacktrace as single detail element
		StringWriter w = new StringWriter();
		cause.printStackTrace(new PrintWriter(w));
		fault.addFaultDetailString(w.toString());
		
		try {
			fault.addFaultDetail(ExceptionProxy.newInstance(cause).toElement());
		}
		catch(Exception e) {}
		
		return fault;
		
	}
	
}
