/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.clients;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.DiscoveryException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.data.tml.clients.APIUtils;
import org.gcube.data.tml.clients.ReaderClient;
import org.gcube.data.tml.clients.WriterClient;
import org.gcube.data.tml.clients.providers.TReaderProvider;
import org.gcube.data.tml.clients.providers.TWriterProvider;
import org.gcube.data.tml.clients.queries.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminAPI {
    private static Logger log = LoggerFactory.getLogger(AdminAPI.class);

    private static <T> Future<T> execute(Callable<T> call) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<T> outcome = executor.submit(call);
        executor.shutdown();
        return outcome;
    }

    private static <T> List<Future<T>> execute(List<Callable<T>> calls) {
        ArrayList<Future<T>> output = new ArrayList<Future<T>>();
        if (calls.size() > 0) {
            ExecutorService executor = Executors.newFixedThreadPool(calls.size());
            for (Callable<T> call : calls) {
                output.add(executor.submit(call));
            }
            executor.shutdown();
        }
        return output;
    }

    public static Future<?> deleteReader(final EndpointReferenceType endpoint) {
        final GCUBEScope scope = GCUBEScopeManager.DEFAULT.getScope();
        return AdminAPI.execute(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GCUBEScopeManager.DEFAULT.setScope(scope);
                log.debug("deleting reader @ {}", (Object)endpoint);
                new ReaderClient(endpoint).delete();
                return null;
            }
        });
    }

    public static Future<?> deleteWriter(final EndpointReferenceType endpoint) throws IllegalArgumentException {
        final GCUBEScope scope = GCUBEScopeManager.DEFAULT.getScope();
        return AdminAPI.execute(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GCUBEScopeManager.DEFAULT.setScope(scope);
                log.debug("deleting reader @ {}", (Object)endpoint);
                new WriterClient(endpoint).delete();
                return null;
            }
        });
    }

    public static List<Future<?>> deleteServices(String sourceId, URL address) throws Exception {
        log.info("deleting all reader and writer services for source {} @ {}", (Object)sourceId, (Object)address);
        ArrayList outcome = new ArrayList();
        EndpointReferenceType endpoint = APIUtils.endpoint(address, TReaderProvider.INSTANCE.name(), sourceId);
        outcome.add(AdminAPI.deleteReader(endpoint));
        endpoint = APIUtils.endpoint(address, TWriterProvider.INSTANCE.name(), sourceId);
        outcome.add(AdminAPI.deleteWriter(endpoint));
        return outcome;
    }

    public static List<Future<EndpointReferenceType>> deleteReaders(String sourceId) throws DiscoveryException {
        log.info("deleting all readers for source {}", (Object)sourceId);
        List endpoints = QueryBuilder.findReadSource().withId(sourceId).build().fire();
        ArrayList calls = new ArrayList();
        for (final EndpointReferenceType endpoint : endpoints) {
            calls.add(new Callable<EndpointReferenceType>(){

                @Override
                public EndpointReferenceType call() throws Exception {
                    AdminAPI.deleteReader(endpoint);
                    return endpoint;
                }
            });
        }
        return AdminAPI.execute(calls);
    }

    public static List<Future<EndpointReferenceType>> deleteWriters(String sourceId) throws DiscoveryException {
        log.info("deleting all writers for source {}", (Object)sourceId);
        List endpoints = QueryBuilder.findWriteSource().withId(sourceId).build().fire();
        ArrayList calls = new ArrayList();
        final GCUBEScope scope = GCUBEScopeManager.DEFAULT.getScope();
        for (final EndpointReferenceType endpoint : endpoints) {
            calls.add(new Callable<EndpointReferenceType>(){

                @Override
                public EndpointReferenceType call() throws Exception {
                    GCUBEScopeManager.DEFAULT.setScope(scope);
                    AdminAPI.deleteReader(endpoint);
                    return endpoint;
                }
            });
        }
        return AdminAPI.execute(calls);
    }

    static List<Future<EndpointReferenceType>> deleteServices(String sourceId) throws DiscoveryException, Exception {
        log.info("deleting all readers and writers for source {}", (Object)sourceId);
        List<Future<EndpointReferenceType>> outcome = AdminAPI.deleteReaders(sourceId);
        outcome.addAll(AdminAPI.deleteWriters(sourceId));
        return outcome;
    }
}

