package org.gcube.data.tml.clients.providers;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.data.tm.stubs.TReaderPortType;
import org.gcube.data.tm.stubs.service.TReaderServiceAddressingLocator;
import org.gcube.data.tml.Constants;

public class TReaderProvider extends AbstractProvider<TReaderPortType> {

	public static final TReaderProvider INSTANCE = new TReaderProvider();
	
	@Override
	public String name() {
		return Constants.TREADER_NAME;
	}

	@Override
	public TReaderPortType service(EndpointReferenceType endpoint) {
		try {
			TReaderPortType pt = new TReaderServiceAddressingLocator().getTReaderPortTypePort(endpoint);
			pt = GCUBERemotePortTypeContext.getProxy(pt,GCUBEScopeManager.DEFAULT);
			return pt;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}


