/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.proxies;

import java.net.URI;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.common.clients.exceptions.UnsupportedRequestException;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.tm.stubs.AnyHolder;
import org.gcube.data.tm.stubs.GetByIDParams;
import org.gcube.data.tm.stubs.GetByIDsParams;
import org.gcube.data.tm.stubs.GetParams;
import org.gcube.data.tm.stubs.Path;
import org.gcube.data.tm.stubs.TReaderPortType;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.tml.utils.TMStreams;
import org.gcube.data.tml.utils.Utils;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.Bindings;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.data.trees.streams.TreeStreams;
import org.w3c.dom.Element;

public class DefaultTReader
implements TReader {
    private final ProxyDelegate<TReaderPortType> delegate;

    public DefaultTReader(ProxyDelegate<TReaderPortType> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Tree get(String id) throws UnknownTreeException {
        try {
            return this.get(id, (Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
        }
        catch (InvalidTreeException e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Tree get(String id, Pattern pattern) throws UnknownTreeException, InvalidTreeException {
        Element element = this.getAsElement(id, pattern);
        try {
            return Bindings.fromElement((Element)element);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    private Element getAsElement(String id, Pattern pattern) throws UnknownTreeException, InvalidTreeException {
        Utils.notNull(new Object[]{"identifier", id});
        Utils.notNull(pattern);
        final GetByIDParams params = new GetByIDParams(Utils.toHolder(pattern), id);
        Call<TReaderPortType, Element> call = new Call<TReaderPortType, Element>(){

            public Element call(TReaderPortType endpoint) throws Exception {
                return Utils.toElement(endpoint.getByID(params));
            }
        };
        try {
            Element e = (Element)this.delegate.make((Call)call);
            if (e == null) {
                throw new ServiceException("unexpected null response");
            }
            return e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(UnknownTreeException.class, InvalidTreeException.class);
        }
    }

    @Override
    public Stream<Tree> get(Stream<String> ids, Pattern pattern) {
        URI locator = Streams.publishStringsIn(ids).withDefaults();
        return this.get(locator, pattern);
    }

    @Override
    public Stream<Tree> get(final URI locator, Pattern pattern) throws UnsupportedOperationException, UnsupportedRequestException, ServiceException {
        Utils.notNull(new Object[]{"resultset locator", locator});
        Utils.notNull(pattern);
        final AnyHolder patternhHolder = Utils.toHolder(pattern);
        Call<TReaderPortType, String> call = new Call<TReaderPortType, String>(){

            public String call(TReaderPortType endpoint) throws Exception {
                GetByIDsParams params = new GetByIDsParams(locator.toString(), patternhHolder);
                return endpoint.getByIDs(params);
            }
        };
        try {
            String outcomeLocator = (String)this.delegate.make((Call)call);
            if (outcomeLocator == null) {
                throw new ServiceException("unexpected null response");
            }
            return TreeStreams.treesIn((URI)URI.create(outcomeLocator));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Stream<Tree> get(final Pattern pattern) {
        Utils.notNull(pattern);
        Call<TReaderPortType, String> call = new Call<TReaderPortType, String>(){

            public String call(TReaderPortType endpoint) throws Exception {
                GetParams params = new GetParams(Utils.toHolder(pattern));
                return endpoint.get(params);
            }
        };
        try {
            String outcomeLocator = (String)this.delegate.make((Call)call);
            if (outcomeLocator == null) {
                throw new ServiceException("unexpected null response");
            }
            return TreeStreams.treesIn((URI)URI.create(outcomeLocator));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    private Element getNodeAsElement(final String ... ids) throws UnknownPathException {
        Utils.notNull(new Object[]{"identifiers", ids});
        Call<TReaderPortType, Element> call = new Call<TReaderPortType, Element>(){

            public Element call(TReaderPortType service) throws Exception {
                return Utils.toElement(service.getNode(new Path(ids)));
            }
        };
        try {
            Element e = (Element)this.delegate.make((Call)call);
            if (e == null) {
                throw new ServiceException("unexpected null response");
            }
            return e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(UnknownPathException.class);
        }
    }

    @Override
    public Node getNode(String ... path) throws UnknownPathException {
        try {
            return Bindings.nodeFromElement((Element)this.getNodeAsElement(path));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(UnknownPathException.class);
        }
    }

    @Override
    public Stream<Node> getNodes(Stream<Path> paths) {
        URI pathRs = TMStreams.publishPathsIn(paths).withDefaults();
        return this.getNodes(pathRs);
    }

    @Override
    public Stream<Node> getNodes(final URI paths) {
        Call<TReaderPortType, String> call = new Call<TReaderPortType, String>(){

            public String call(TReaderPortType endpoint) throws Exception {
                return endpoint.getNodes(paths.toString());
            }
        };
        try {
            String locator = (String)this.delegate.make((Call)call);
            return TreeStreams.nodesIn((URI)URI.create(locator));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

