/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.utils;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import javax.xml.namespace.QName;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.dsl.publish.PublishRsWithClause;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tm.stubs.Path;
import org.gcube.data.tml.utils.TMStreamLogger;
import org.gcube.data.trees.data.Node;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.xml.sax.InputSource;

public class TMStreams {
    public static <N extends Node> Stream<N> log(Stream<N> stream) {
        TMStreamLogger logger = new TMStreamLogger();
        return Streams.monitor((Stream)Streams.pipe(stream).through(logger)).with(logger);
    }

    public static Stream<Path> pathsIn(URI locator) {
        return Streams.pipe((Stream)Streams.stringsIn((URI)locator)).through((Generator)new PathParser());
    }

    public static PublishRsWithClause<Path> publishPathsIn(Stream<Path> stream) {
        return Streams.publish(stream).using((Generator)new PathSerialiser());
    }

    private static class PathSerialiser
    implements Generator<Path, String> {
        private PathSerialiser() {
        }

        public String yield(Path path) {
            try {
                StringWriter w = new StringWriter();
                ObjectSerializer.serialize((Writer)w, (Object)path, (QName)Path.getTypeDesc().getXmlType());
                return w.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PathParser
    implements Generator<String, Path> {
        private PathParser() {
        }

        public Path yield(String element) {
            try {
                return (Path)ObjectDeserializer.deserialize((InputSource)new InputSource(new StringReader(element)), Path.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

