package org.acme.sample.tmplugin;


import java.util.Collections;
import java.util.List;

import org.acme.sample.tmplugin.requests.SampleRequest;
import org.gcube.data.tmf.api.Plugin;
import org.gcube.data.tmf.api.Property;

public class SamplePlugin implements Plugin {

	@Override
	public String name() {
		return "sample-tree-plugin";
	}
	
	@Override
	public String description() {
		return "a sample plugin of the Tree Manager service";
	}
	
	@Override
	public List<Property> properties() {
		return Collections.singletonList(new Property("a sample property", "prop", "propval"));
	}
	
	@Override
	public SampleBinder binder() {
		return new SampleBinder();
	}
	
	@Override
	public List<String> requestSchemas() {
		
		String sampleDataSchema = Utils.toSchema(SampleRequest.class);
		
		return Collections.singletonList(sampleDataSchema);
	}
	
	@Override
	public boolean isAnchored() {
		return false;
	}
}
