package org.acme.sample.tmplugin;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;

import org.acme.sample.tmplugin.data.DataBinder;
import org.acme.sample.tmplugin.requests.BindMode;
import org.acme.sample.tmplugin.requests.SampleRequest;
import org.gcube.data.tmf.api.SourceBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SampleBinder implements SourceBinder {

	private static Logger log = LoggerFactory.getLogger(SampleBinder.class);
	
	private static DataBinder db = new DataBinder();
	
	
	@Override
	public List<? extends SampleSource> bind(Element request) throws Exception {
		
		//parse request
		SampleRequest boundRequest = db.bind(request);
		
		//create single source
		SampleSource source = new SampleSource(boundRequest.id());
		source.setDescription(boundRequest.description());
		source.setCreationTime(Calendar.getInstance());
		
		//bind lifecycle
		SampleLifecycle lc = new SampleLifecycle(source);
		source.setLifecycle(lc);
		
		BindMode mode = boundRequest.mode();
		
		if (mode==BindMode.FULL || mode==BindMode.READ_ONLY) {
			SampleReader reader = new SampleReader(source);
			source.setReader(reader);	
		}
		
		if (mode==BindMode.FULL || mode==BindMode.WRITE_ONLY) {
			SampleWriter reader = new SampleWriter(source);
			source.setWriter(reader);	
		}
		
		log.info("bound source {}",source);
		
		return Collections.singletonList(source);
	}
}
