package org.acme.sample.tmplugin.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;


public class SampleStore implements Serializable {

	private static final long serialVersionUID = 1L;
	
	public static final int START_SIZE=10;

	private Map<String,SampleData> data = new LinkedHashMap<String,SampleData>();
	
	public SampleStore() {
		for (int i=0;i<START_SIZE;i++) //synthetise some test data
			data.put(id(i),new SampleData(id(i),i));
	}
	
	public List<SampleData> getAll() {
		return new ArrayList<SampleData>(data.values());
	}
	
	public SampleData get(String id) {
		return data.get(id);
	}
	
	public synchronized SampleData add(SampleData newData) {
		
		SampleData clone = new SampleData (id(data.size()),newData.val());
		data.put(clone.id(),clone);
		return clone;
	}
	
	public synchronized void remove(String id) {
		data.remove(id);
	}
	
	public synchronized void update(SampleData modifiedData) {
		
		data.put(modifiedData.id(),modifiedData);
	}


	//helper
	private String id(int i) {
		return "id"+i;
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((data == null) ? 0 : data.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SampleStore other = (SampleStore) obj;
		if (data == null) {
			if (other.data != null)
				return false;
		} else if (!data.equals(other.data))
			return false;
		return true;
	}
	
	
}
