package org.acme.sample.tmplugin;

import java.util.ArrayList;
import java.util.List;

import org.acme.sample.tmplugin.data.DataBinder;
import org.acme.sample.tmplugin.data.SampleData;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.tmf.impl.AbstractReader;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.patterns.Pattern;

public class SampleReader extends AbstractReader {

	private static final long serialVersionUID = 1L;

	private SampleSource source;
	private DataBinder db = new DataBinder();
	
	public SampleReader(SampleSource source) {
		this.source=source;
	}
	
	@Override
	public Stream<Tree> get(Pattern pattern) throws Exception {
		List<Tree> trees = new ArrayList<Tree>();
		for (SampleData data : source.store().getAll()) {
			Tree tree = db.bind(data);
			try {
				pattern.prune(tree);
				trees.add(tree);
			}
			catch(Exception exclude) {}
		}
		return Streams.convert(trees.iterator());
	}

	@Override
	public Tree get(String id, Pattern pattern) throws UnknownTreeException,InvalidTreeException, Exception {
		
		//as basic as it gets
		for (SampleData data : source.store().getAll())
			if (data.id().equals(id)) {
				Tree tree = db.bind(data);
				try {
					pattern.prune(tree);
					return tree;
				}
				catch(Exception e) {
					throw new InvalidTreeException(tree+" does not match "+pattern,e);
				}
			}
		
		throw new UnknownTreeException("no such tree: "+id);	
	}
	
}
