/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.context;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.data.streams.publishers.ThreadProvider;
import org.gcube.data.tm.activationrecord.ActivationRecord;
import org.gcube.data.tm.activationrecord.ActivationRecordBody;
import org.gcube.data.tm.consumers.ActivationRecordConsumer;
import org.gcube.data.tm.consumers.SourceRemovalConsumer;
import org.gcube.data.tm.context.TBinderContext;
import org.gcube.data.tm.plugin.PluginManager;
import org.gcube.data.tml.proxies.BindParams;

public class ServiceContext
extends GCUBEServiceContext {
    private static ServiceContext cache = new ServiceContext();
    private List<ISNotifier.GCUBENotificationTopic> registeredNotficationTopic = new ArrayList<ISNotifier.GCUBENotificationTopic>();
    private JAXBContext binder;
    private static final ThreadProvider provider = new ThreadProvider(){

        public Thread newThread(Runnable r) {
            return ServiceContext.getContext().newServiceThread(r);
        }
    };

    public static ServiceContext getContext() {
        return cache;
    }

    private ServiceContext() {
    }

    protected String getJNDIName() {
        return "gcube/data/tm";
    }

    public synchronized JAXBContext getDataBinder() throws Exception {
        if (this.binder == null) {
            this.binder = JAXBContext.newInstance((Class[])new Class[]{ActivationRecordBody.class, BindParams.class});
        }
        return this.binder;
    }

    protected void onReady() throws Exception {
        super.onReady();
        this.initialisegRS2();
        this.logger.info((Object)"creating T-Binder resources in all RI scopes");
        TBinderContext binderContext = TBinderContext.getContext();
        for (GCUBEScope scope : this.getInstance().getScopes().values()) {
            this.setScope(scope);
            binderContext.createBinder();
        }
        if (GHNContext.getContext().getMode() == GHNContext.Mode.CONNECTED) {
            this.selfStage();
        }
    }

    protected void onShutdown() throws Exception {
        if (GHNContext.getContext().getMode() == GHNContext.Mode.CONNECTED) {
            ISNotifier notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
            for (GCUBEScope scope : this.getInstance().getScopes().values()) {
                notifier.unregisterFromISNotification((GCUBESecurityManager)this, this.registeredNotficationTopic, new GCUBEScope[]{scope});
            }
        }
        new PluginManager().stop();
    }

    protected void onFailure() throws Exception {
        new PluginManager().stop();
    }

    private void selfStage() throws Exception {
        this.stageForActivationRecords();
        this.stageForSourceProfiles();
    }

    private void stageForActivationRecords() throws Exception {
        ISNotifier notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        ISNotifier.GCUBENotificationTopic notificationTopic = new ISNotifier.GCUBENotificationTopic(new QName("http://gcube-system.org/namespaces/informationsystem/registry", "GenericResource"));
        notificationTopic.setPrecondition("//profile[contains(.,'<SecondaryType>ActivationRecord</SecondaryType>') and contains(.,'<Name>TMRecord</Name>')] and //operationType[text()='create']");
        this.registeredNotficationTopic.add(notificationTopic);
        List<ISNotifier.GCUBENotificationTopic> topic = Collections.singletonList(notificationTopic);
        for (GCUBEScope scope : this.getInstance().getScopes().values()) {
            this.logger.trace((Object)("looking for activation records in " + scope));
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            String thisServiceCondition = String.format("$result/Profile/Name eq '%1$s'", "TMRecord");
            query.addGenericCondition(thisServiceCondition);
            String notSameRICondition = String.format("$result/descendant::*[local-name()='createdBy'] ne '%1$s'", this.getInstance().getID());
            query.addGenericCondition(notSameRICondition);
            final List resources = client.execute((ISQuery)query, scope);
            final ActivationRecordConsumer consumer = new ActivationRecordConsumer(scope);
            final CountDownLatch latch = new CountDownLatch(1);
            if (resources.size() > 0) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        for (GCUBEGenericResource resource : resources) {
                            consumer.onNewActivationRecord(ActivationRecord.newInstance(resource));
                        }
                    }
                }.start();
            }
            this.logger.trace((Object)("subscribing for activation records in " + scope));
            notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)consumer, topic, (GCUBESecurityManager)this, new GCUBEScope[]{scope});
            latch.countDown();
        }
    }

    private void stageForSourceProfiles() throws Exception {
        ISNotifier notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
        ISNotifier.GCUBENotificationTopic notificationTopic = new ISNotifier.GCUBENotificationTopic(new QName("http://gcube-system.org/namespaces/informationsystem/registry", "GenericResource"));
        notificationTopic.setPrecondition("//operationType/[text()='destroy']");
        this.registeredNotficationTopic.add(notificationTopic);
        List<ISNotifier.GCUBENotificationTopic> topic = Collections.singletonList(notificationTopic);
        for (GCUBEScope scope : this.getInstance().getScopes().values()) {
            this.logger.trace((Object)("subscribing for collection profile removals in " + scope));
            notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)new SourceRemovalConsumer(scope), topic, (GCUBESecurityManager)this, new GCUBEScope[]{scope});
        }
    }

    public Thread newServiceThread(Runnable r) {
        Thread t = new Thread(r);
        this.setScope(t, new GCUBEScope[0]);
        return t;
    }

    private void initialisegRS2() throws UnknownHostException {
        ArrayList<PortRange> ports = new ArrayList<PortRange>();
        ports.add(new PortRange(3050, 3100));
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            host = "localhost";
        }
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(host, ports, true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }

    public ThreadProvider threadProvider() {
        return provider;
    }
}

