/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.services;

import java.net.URI;
import java.net.URISyntaxException;
import org.gcube.common.clients.exceptions.UnsupportedRequestException;
import org.gcube.common.core.faults.FaultUtils;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.data.streams.Stream;
import org.gcube.data.tm.context.ServiceContext;
import org.gcube.data.tm.context.TWriterContext;
import org.gcube.data.tm.state.TWriterResource;
import org.gcube.data.tm.stubs.AnyHolder;
import org.gcube.data.tm.stubs.InvalidTreeFault;
import org.gcube.data.tm.stubs.UnknownTreeFault;
import org.gcube.data.tm.stubs.UnsupportedOperationFault;
import org.gcube.data.tm.stubs.UnsupportedRequestFault;
import org.gcube.data.tmf.api.SourceWriter;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.utils.Utils;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.streams.TreeStreams;

public class TWriterService {
    public TWriterResource resource() throws Exception {
        return (TWriterResource)TWriterContext.getContext().getWSHome().find();
    }

    public AnyHolder add(AnyHolder tree) throws UnsupportedOperationFault, UnsupportedRequestFault, InvalidTreeFault, GCUBEFault {
        try {
            SourceWriter writer = this.resource().writer();
            return Utils.toHolder((Tree)writer.add(Utils.toTree((AnyHolder)tree)));
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (InvalidTreeException e) {
            throw (InvalidTreeFault)FaultUtils.newFault((GCUBEFault)new InvalidTreeFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String addRS(String locator) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Stream inputTrees = TreeStreams.treesIn((URI)new URI(locator));
            SourceWriter writer = this.resource().writer();
            Stream outcomes = writer.add(inputTrees);
            URI outcomeLocator = TreeStreams.publishTreesIn((Stream)outcomes).withBufferOf(25).with(ServiceContext.getContext().threadProvider()).withDefaults();
            return outcomeLocator.toString();
        }
        catch (URISyntaxException e) {
            throw (GCUBEUnrecoverableFault)FaultUtils.newFault((GCUBEFault)new GCUBEUnrecoverableFault(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public AnyHolder update(AnyHolder delta) throws UnsupportedOperationFault, UnsupportedRequestFault, UnknownTreeFault, InvalidTreeFault, GCUBEFault {
        try {
            SourceWriter writer = this.resource().writer();
            return Utils.toHolder((Tree)writer.update(Utils.toTree((AnyHolder)delta)));
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (UnknownTreeException e) {
            throw (UnknownTreeFault)FaultUtils.newFault((GCUBEFault)new UnknownTreeFault(), (Throwable)e);
        }
        catch (InvalidTreeException e) {
            throw (InvalidTreeFault)FaultUtils.newFault((GCUBEFault)new InvalidTreeFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String updateRS(String locator) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            SourceWriter writer = this.resource().writer();
            Stream deltaStream = TreeStreams.treesIn((URI)new URI(locator));
            Stream failures = writer.update(deltaStream);
            URI outcomeLocator = TreeStreams.publishTreesIn((Stream)failures).withBufferOf(25).with(ServiceContext.getContext().threadProvider()).withDefaults();
            return outcomeLocator.toString();
        }
        catch (URISyntaxException e) {
            throw (GCUBEUnrecoverableFault)FaultUtils.newFault((GCUBEFault)new GCUBEUnrecoverableFault(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }
}

