package org.gcube.data.tm.plugin;

import java.io.IOException;
import java.io.ObjectOutputStream;

import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.data.tmf.api.SourceConsumer;
import org.gcube.data.tmf.api.SourceEvent;
import org.gcube.data.tmf.api.SourceLifecycle;
import org.gcube.data.tmf.api.SourceNotifier;
import org.gcube.data.tmf.api.SourceReader;
import org.gcube.data.tmf.api.SourceWriter;

/**
 * A {@link SourceNotifier} based on {@link GCUBEProducer}s and {@link GCUBEConsumer}s.
 * 
 * @author Fabio Simeoni
 *
 */
@SuppressWarnings("all")
public class DefaultSourceNotifier implements SourceNotifier {

	private static final long serialVersionUID = 1L;
	
	transient GCUBEProducer<SourceEvent,Void> producer;
	
	public DefaultSourceNotifier() {
		setProducer();
	}
	
	private void setProducer() {
		producer=new GCUBEProducer<SourceEvent, Void>();
	}
	
	private static class ConsumerAdapter implements GCUBEConsumer<SourceEvent,Void> {
		
		private SourceConsumer consumer;
		
		ConsumerAdapter(SourceConsumer consumer) {
			this.consumer=consumer;
		}
		
		public <T1 extends SourceEvent, P1 extends Void> void onEvent(GCUBEEvent<T1,P1> ... events) {
			for (GCUBEEvent<T1,P1> event : events)
				consumer.onEvent(event.getTopic());
		};
	}
	
	@Override
	public void subscribe(SourceConsumer consumer, SourceEvent ... topics) {
		producer.subscribe(new ConsumerAdapter(consumer), topics);
	};
	
	@Override
	public void notify(SourceEvent topic) {
		producer.notify(topic,new GCUBEEvent<SourceEvent,Void>());
	}
	
	/**
	 * @serialData the {@link SourceLifecycle}, the {@link SourceReader} and the {@link SourceWriter}.
	 */
	 private void writeObject(ObjectOutputStream out) throws IOException {
		out.defaultWriteObject();
	 }
	
    //invoked upon deserialisation, resets non-serializable defaults
	private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
		 
		 in.defaultReadObject();
		 
		 setProducer();
		 
	 }
}
