/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.io;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import org.gcube.data.trees.io.BinderHome;
import org.gcube.data.trees.io.BinderInfo;
import org.gcube.data.trees.io.TreeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinderLoader
implements BinderHome {
    private static Logger log = LoggerFactory.getLogger(BinderLoader.class);

    @Override
    public synchronized Map<String, TreeBinder<?>> binders() {
        HashMap binders = new HashMap();
        ServiceLoader<TreeBinder> loader = ServiceLoader.load(TreeBinder.class);
        for (TreeBinder binder : loader) {
            try {
                this.checkBinder(binder);
                binders.put(binder.info().name(), binder);
            }
            catch (Throwable error) {
                log.warn("problem loading tree binder " + error.getMessage());
            }
        }
        return binders;
    }

    private void checkBinder(TreeBinder<?> binder) throws Exception {
        BinderInfo info = binder.info();
        if (info == null) {
            throw new Exception("malformed binder: info is null");
        }
        if (info.name() == null || info.name().isEmpty()) {
            throw new Exception("malformed binder: name is null or empty");
        }
        QName name = info.treeForm();
        if (name == null || name.getLocalPart() == null || name.getLocalPart().isEmpty()) {
            throw new Exception("malformed binder: tree form is null or empty");
        }
        name = info.type();
        if (name == null || name.getLocalPart() == null || name.getLocalPart().isEmpty()) {
            throw new Exception("malformed binder: data type is null or empty");
        }
    }
}

