/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.uri;

import java.net.URI;
import java.util.List;
import org.gcube.common.uri.UriBean;

public class TreeUriBean {
    private final UriBean bean;
    private final String sourceId;
    private final String treeId;
    private final String nodeId;
    private final List<String> nodeIds;

    public TreeUriBean(URI uri) throws IllegalArgumentException {
        this.bean = new UriBean(uri);
        List elements = this.bean.elements();
        try {
            this.sourceId = (String)elements.get(1);
            this.treeId = (String)elements.get(2);
            this.nodeId = (String)elements.get(elements.size() - 1);
            this.nodeIds = elements.subList(2, elements.size() - 1);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.bean + " is not a valid tree URI", e);
        }
    }

    public String sourceId() {
        return this.sourceId;
    }

    public String treeId() {
        return this.treeId;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public List<String> nodeIDs() {
        return this.nodeIds;
    }

    public URI url() {
        return this.bean.uri();
    }

    public String toString() {
        return this.bean.toString();
    }

    public String scope() {
        return this.bean.scope();
    }
}

