/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.data;

import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;

@XmlRootElement
public class Tree
extends InnerNode {
    private String sourceId;

    public Tree(Tree tree) {
        super(tree);
        this.sourceId = tree.sourceId;
    }

    public Tree() {
        super(new Edge[0]);
    }

    public Tree(String id) {
        super(id);
    }

    public Tree(String id, Edge ... edges) {
        super(id, edges);
    }

    public Tree(Edge ... edges) {
        super(edges);
    }

    public Tree(String sourceId, String id, Edge ... edges) {
        this(id, edges);
        this.setSourceId(sourceId);
    }

    public Tree(String id, Map<QName, String> attributes, Edge ... edges) {
        super(id, attributes, edges);
    }

    public Tree(String id, Node.State state, Map<QName, String> attributes, Edge ... edges) {
        super(id, state, attributes, edges);
    }

    public void setSourceId(String id) {
        this.sourceId = id;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public synchronized Tree delta(Tree future) throws IllegalArgumentException {
        Tree delta = (Tree)super.delta(future);
        if (delta.state() == null) {
            return null;
        }
        delta.setSourceId(this.sourceId());
        return delta;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[").append(this.state() == null ? "" : this.state().name() + " ").append(this.id() != null ? "id:" + (this.id().length() > 3 ? this.id().substring(0, Math.min(this.id().length(), 3)) + ".." : this.id()) + " " : "");
        b.append(this.sourceId() != null ? " sourceId:" + (this.sourceId().length() > 3 ? this.sourceId().substring(0, Math.min(this.sourceId().length(), 3)) + ".." : this.sourceId()) + " " : "");
        for (Map.Entry<QName, String> attr : this.attributes().entrySet()) {
            b.append("@" + (attr.getKey().getPrefix().length() > 0 ? attr.getKey().getPrefix() + ":" : "") + attr.getKey() + "=" + attr.getValue() + " ");
        }
        for (Edge e : this.edges()) {
            b.append(e + " ");
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sourceId == null ? 0 : this.sourceId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tree other = (Tree)obj;
        return !(this.sourceId == null ? other.sourceId != null : !this.sourceId.equals(other.sourceId));
    }
}

