/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.dataminermanagercl.server.monitor;

import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.server.monitor.DMMonitorListener;
import org.gcube.data.analysis.dataminermanagercl.server.monitor.DMMonitorTask;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMMonitor {
    private static Logger logger = LoggerFactory.getLogger(DMMonitor.class);
    private int sleep = 2000;
    private int delay = 2000;
    private int period = 2000;
    private ComputationId computationId;
    private SClient sClient;
    private ArrayList<DMMonitorListener> listeners = new ArrayList();
    private Timer timer;
    private boolean notEnd;

    public DMMonitor(ComputationId computationId, SClient sClient) {
        logger.debug("DMMonitor");
        this.computationId = computationId;
        this.sClient = sClient;
    }

    public void add(DMMonitorListener listener) {
        this.listeners.add(listener);
    }

    public void addAll(ArrayList<DMMonitorListener> listeners) {
        this.listeners.addAll(listeners);
    }

    public void start() {
        try {
            logger.debug("Start Monitoring");
            this.notEnd = true;
            this.timer = new Timer(false);
            DMMonitorTask dmMonitorTask = new DMMonitorTask(this, this.computationId, this.sClient, this.listeners);
            logger.debug("Start: " + new Date());
            this.timer.schedule((TimerTask)dmMonitorTask, this.delay, (long)this.period);
            while (this.notEnd) {
                Thread.sleep(this.sleep);
            }
            logger.debug("End run");
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void cancel() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.notEnd = false;
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }
}

