/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.dataminermanagercl.shared.parameters;

import java.util.Arrays;
import java.util.List;

public enum WKTGeometryType {
    Point("Point"),
    LineString("LineString"),
    Polygon("Polygon"),
    Circle("Circle"),
    Triangle("Triangle"),
    Square("Square"),
    Pentagon("Pentagon"),
    Hexagon("Hexagon"),
    Box("Box");

    private final String label;

    private WKTGeometryType(String label) {
        this.label = label;
    }

    public String toString() {
        return this.label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.name();
    }

    public static WKTGeometryType getFromLabel(String label) {
        if (label == null || label.isEmpty()) {
            return null;
        }
        for (WKTGeometryType type : WKTGeometryType.values()) {
            if (type.label.compareToIgnoreCase(label) != 0) continue;
            return type;
        }
        return null;
    }

    public static List<WKTGeometryType> asList() {
        List<WKTGeometryType> list = Arrays.asList(WKTGeometryType.values());
        return list;
    }
}

