/**
 *
 */
package org.gcube.data.analysis.dminvocation.model;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import org.gcube.data.analysis.dminvocation.ActionType;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;

/**
 * The Class DataMinerInvocation.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * Dec 4, 2018
 */
@XmlRootElement(name = "dataminer-invocation")
@JsonRootName(value = "dataminer-invocation")
@XmlAccessorType (XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true)
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@ToString
public class DataMinerInvocation implements Serializable{

	/**
	 *
	 */
	private static final long serialVersionUID = 8506240125306265159L;


	@XmlElement(name = "operator-id", required=true, nillable=false)
	@JsonProperty(value="operator-id", required=true)
	private String operatorId;

	@XmlElement(name = "action", required=true, nillable=false)
	@JsonProperty(value="action", required=true)
	private ActionType actionType = ActionType.RUN;

	@XmlElement(name = "parameters", required=false, nillable=false)
	@JsonProperty(required=false)
	private DataMinerParameters parameters;

}
