/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.websocketx;

import java.net.URI;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketUtil;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketClientHandshaker13
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker13.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private static final String protocol = null;
    private final boolean allowExtensions;

    public WebSocketClientHandshaker13(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, Map<String, String> customHeaders) {
        super(webSocketURL, version, subprotocol, customHeaders);
        this.allowExtensions = allowExtensions;
    }

    @Override
    public ChannelFuture handshake(Channel channel) {
        URI wsURL = this.getWebSocketUrl();
        String path = wsURL.getPath();
        if (wsURL.getQuery() != null && wsURL.getQuery().length() > 0) {
            path = wsURL.getPath() + "?" + wsURL.getQuery();
        }
        byte[] nonce = WebSocketUtil.randomBytes(16);
        String key = WebSocketUtil.base64(nonce);
        String acceptSeed = key + MAGIC_GUID;
        byte[] sha1 = WebSocketUtil.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("WS Version 13 Client Handshake key: %s. Expected response: %s.", key, this.expectedChallengeResponseString));
        }
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
        request.addHeader("Upgrade", "WebSocket".toLowerCase());
        request.addHeader("Connection", "Upgrade");
        request.addHeader("Sec-WebSocket-Key", key);
        request.addHeader("Host", wsURL.getHost());
        request.addHeader("Origin", "http://" + wsURL.getHost());
        if (protocol != null && !protocol.equals("")) {
            request.addHeader("Sec-WebSocket-Protocol", protocol);
        }
        request.addHeader("Sec-WebSocket-Version", "13");
        if (this.customHeaders != null) {
            for (String header : this.customHeaders.keySet()) {
                request.addHeader(header, this.customHeaders.get(header));
            }
        }
        ChannelFuture future = channel.write(request);
        channel.getPipeline().replace(HttpRequestEncoder.class, "ws-encoder", (ChannelHandler)new WebSocket13FrameEncoder(true));
        return future;
    }

    @Override
    public void finishHandshake(Channel channel, HttpResponse response) throws WebSocketHandshakeException {
        HttpResponseStatus status = HttpResponseStatus.SWITCHING_PROTOCOLS;
        if (!response.getStatus().equals(status)) {
            throw new WebSocketHandshakeException("Invalid handshake response status: " + response.getStatus());
        }
        String upgrade = response.getHeader("Upgrade");
        if (upgrade == null || !upgrade.equals("WebSocket".toLowerCase())) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + response.getHeader("Upgrade"));
        }
        String connection = response.getHeader("Connection");
        if (connection == null || !connection.equals("Upgrade")) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + response.getHeader("Connection"));
        }
        String accept = response.getHeader("Sec-WebSocket-Accept");
        if (accept == null || !accept.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, this.expectedChallengeResponseString));
        }
        channel.getPipeline().replace(HttpResponseDecoder.class, "ws-decoder", (ChannelHandler)new WebSocket13FrameDecoder(false, this.allowExtensions));
        this.setHandshakeComplete();
    }
}

