/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.nlphub.nlp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.data.analysis.nlphub.is.DMDiscover;
import org.gcube.data.analysis.nlphub.legacy.AsyncHttpRequest;
import org.gcube.data.analysis.nlphub.nlp.NlpParameter;
import org.gcube.data.analysis.nlphub.nlp.RunnerCommander;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class NlpAsyncNerRunner
extends AsyncHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(NlpAsyncNerRunner.class);
    public static final String WPS_EXECUTE_URL = "?request=Execute&service=WPS&Version=1.0.0";
    public static final String WPS_DESCRIBE_PROCESS_URL = "?request=DescribeProcess&service=WPS&Version=1.0.0";
    private String identifier;
    private RunnerCommander commander;

    public NlpAsyncNerRunner(String dataMiner, String identifier, String token, String publicLink, String annotations, String language, RunnerCommander commander) throws Exception {
        this.commander = commander;
        this.identifier = identifier;
        String httpMethod = "GET";
        if (dataMiner == null || dataMiner.isEmpty()) {
            try {
                DMDiscover discoverDataMinerService = new DMDiscover();
                dataMiner = discoverDataMinerService.retrieveServiceUrl(token);
            }
            catch (Exception e) {
                logger.error("Error retrieving DataMiner service:" + e.getMessage(), (Throwable)e);
                throw new Exception("Error retrieving DataMiner service:" + e.getMessage());
            }
        }
        logger.debug("NlpAsyncNerRunner: Create Excution Request");
        logger.debug("NlpAsyncNerRunner: [identifier=" + identifier + ", httpMethod=" + httpMethod + ", annotations=" + annotations + ", publicLink=" + publicLink + ", dataminer=" + dataMiner + "]");
        ArrayList params = this.buildParameterString(dataMiner, identifier, publicLink, annotations, token);
        StringBuilder serviceUrl = new StringBuilder();
        serviceUrl.append(dataMiner);
        serviceUrl.append(WPS_EXECUTE_URL);
        serviceUrl.append("&lang=en-US&Identifier=");
        serviceUrl.append(identifier);
        serviceUrl.append("&");
        serviceUrl.append(this.setParams(params));
        serviceUrl.append("&gcube-token=" + token);
        logger.debug("NlpAsyncNerRunner: [serviceUrl=" + serviceUrl + ", method=" + httpMethod + "]");
        super.setBaseUrl(serviceUrl.toString());
        super.setMethod(httpMethod);
    }

    private String setParams(ArrayList<NlpParameter> parameters) {
        logger.debug("Set Params");
        String url = "DataInputs=";
        for (NlpParameter p : parameters) {
            try {
                url = url + p.getName() + "=" + URLEncoder.encode((String)p.getValue(), "UTF-8") + ";";
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage());
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<NlpParameter> buildParameterString(String dataMiner, String identifier, String publicLink, String annotations, String token) {
        ArrayList<NlpParameter> parameters = new ArrayList<NlpParameter>();
        HttpURLConnection connection = null;
        BufferedReader r = null;
        try {
            StringBuilder serviceUrl = new StringBuilder();
            serviceUrl.append(dataMiner);
            serviceUrl.append(WPS_DESCRIBE_PROCESS_URL);
            serviceUrl.append("&lang=en-US&Identifier=");
            serviceUrl.append(identifier);
            logger.debug("DescribeProcess Requested: " + serviceUrl);
            serviceUrl.append("&gcube-token=");
            serviceUrl.append(token);
            URL url = new URL(serviceUrl.toString());
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.setUseCaches(false);
            r = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(r));
            doc.getDocumentElement().normalize();
            NodeList nListInput = doc.getElementsByTagName("Input");
            for (int i = 0; i < nListInput.getLength(); ++i) {
                Node nodeInput = nListInput.item(i);
                NlpParameter nlpParam = new NlpParameter();
                NodeList inputChildren = nodeInput.getChildNodes();
                for (int j = 0; j < inputChildren.getLength(); ++j) {
                    Node node = inputChildren.item(j);
                    if (node.getNodeName().equals("ows:Identifier")) {
                        nlpParam.setName(node.getTextContent());
                        continue;
                    }
                    if (node.getNodeName().equals("ows:Title")) {
                        nlpParam.setDescription(node.getTextContent());
                        continue;
                    }
                    if (!node.getNodeName().equals("ows:Abstract")) continue;
                    String text = node.getTextContent().toLowerCase();
                    if (text.indexOf("file") >= 0 || text.indexOf("text") >= 0) {
                        nlpParam.setObjectType(NlpParameter.INPUT_FILE);
                        nlpParam.setValue((Object)publicLink);
                        continue;
                    }
                    if (text.indexOf("annotation") < 0 && text.indexOf("list") < 0) continue;
                    nlpParam.setObjectType(NlpParameter.INPUT_ANNOTATIONS);
                    nlpParam.setValue((Object)annotations.replaceAll(",", "|"));
                }
                parameters.add(nlpParam);
            }
        }
        catch (Exception e) {
            logger.error("NlpAsyncNerRunner buildParameterString: " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return parameters;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void asyncHttpRequestCallback() {
        this.elapsedTime = System.currentTimeMillis() - this.elapsedTime;
        logger.debug("ID: " + this.identifier.substring(this.identifier.lastIndexOf(".") + 1) + " elapsed time: " + this.elapsedTime);
        String result = super.getResult();
        String theLink = "";
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8))));
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(r));
            doc.getDocumentElement().normalize();
            NodeList nListResult = doc.getElementsByTagName("ogr:Result");
            int found = 0;
            for (int i = 0; i < nListResult.getLength() && found == 0; ++i) {
                Node nodeResult = nListResult.item(i);
                NodeList list = nodeResult.getChildNodes();
                String res = "";
                for (int j = 0; j < list.getLength(); ++j) {
                    Node node = list.item(j);
                    if (node.getNodeName().equals("d4science:Data")) {
                        res = node.getTextContent();
                        continue;
                    }
                    if (!node.getNodeName().equals("d4science:MimeType") || !node.getTextContent().equals("application/d4science")) continue;
                    found = 1;
                }
                if (found <= 0) continue;
                theLink = res;
            }
            this.commander.updateResultList(this.identifier.substring(this.identifier.lastIndexOf(".") + 1) + ":::" + theLink);
        }
        catch (Exception e) {
            this.commander.updateResultList(this.identifier.substring(this.identifier.lastIndexOf(".") + 1) + ":::" + "ERROR");
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

