package org.gcube.data.analysis.nlphub.session;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.gcube.data.analysis.nlphub.shared.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtils {
	private static final Logger logger = LoggerFactory.getLogger(SessionUtils.class);

	public static String getToken(HttpServletRequest request) throws ServletException {
		String token = request.getParameter(Constants.TOKEN_PARAMETER);
		logger.debug("Token in request: " + token);
		if (token == null || token.isEmpty()) {
			logger.debug("Token is null");
			throw new ServletException("Token is null");
		}
		return token;
	}

	/*
	private static void checkToken(String token) throws Exception {
		if (token == null || token.isEmpty()) {
			logger.error("Token is null");
			throw new Exception("Token is null");
		} else {
			AuthorizationEntry entry;

			entry = authorizationService().get(token);
			ClientInfo clientInfo = entry.getClientInfo();
			if (clientInfo == null) {
				logger.error("User not found.");
				throw new Exception("Authorization failed!");
			} else {
				logger.debug("User: " + clientInfo.getId());
				String context = entry.getContext();
				logger.debug("Context: " + context);
			}

		}

	}*/

}
