/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.nlphub.session;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtils {
    private static final Logger logger = LoggerFactory.getLogger(SessionUtils.class);

    public String getToken(HttpServletRequest request) throws ServletException {
        String token = request.getParameter("gcube-token");
        logger.debug("Token in request: " + token);
        if (token == null || token.isEmpty()) {
            logger.debug("Token is null");
            throw new ServletException("Token is null");
        }
        this.setAuth(token);
        return token;
    }

    private void setAuth(String token) throws ServletException {
        try {
            SecurityTokenProvider.instance.set(token);
            AuthorizationEntry authorizationEntry = Constants.authorizationService().get(token);
            ClientInfo clientInfo = authorizationEntry.getClientInfo();
            logger.debug("User : {} - Type : {}", (Object)clientInfo.getId(), (Object)clientInfo.getType().name());
            String qualifier = authorizationEntry.getQualifier();
            Caller caller = new Caller(clientInfo, qualifier);
            AuthorizationProvider.instance.set(caller);
            ScopeProvider.instance.set(authorizationEntry.getContext());
        }
        catch (Exception e) {
            logger.error("Error in set context: " + e.getLocalizedMessage(), (Throwable)e);
            throw new ServletException("Error in set context: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

