/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.nlphub.legacy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonManager {
    private static final Logger logger = LoggerFactory.getLogger(JsonManager.class);
    public static String TEXT = "text";
    public static String ANNOTATIONS = "annotations";
    public static String LANGUAGE = "language";
    public static String ALGORITHM = "algorithm";
    public static String ENTITIES = "entities";
    public static String INDICES = "indices";
    public static String RESULT = "result";
    public static String RESPONSE = "response";
    public static String OK = "Ok";
    public static String ERROR = "Error";
    public static String MESSAGE = "message";
    private JsonObject jsonObjectRoot = null;

    public JsonManager() {
        logger.debug("JsonManager");
        this.jsonObjectRoot = new JsonObject();
    }

    public JsonManager(String s) {
        this.jsonObjectRoot = (JsonObject)new JsonParser().parse(s);
    }

    public JsonManager(Reader r) {
        this.jsonObjectRoot = (JsonObject)new JsonParser().parse(r);
    }

    public String getJsonAsString() {
        return this.jsonObjectRoot.toString();
    }

    public String getSuccessJsonResponse(String[] messages) {
        this.jsonObjectRoot.addProperty(RESPONSE, OK);
        JsonArray msgs = new JsonArray();
        for (String m : messages) {
            msgs.add(m);
        }
        this.jsonObjectRoot.add(MESSAGE, (JsonElement)msgs);
        return this.jsonObjectRoot.toString();
    }

    public String getSuccessJsonResponse(String message) {
        return this.getResponse(true, message);
    }

    public String getErrorJsonResponse(String message) {
        return this.getResponse(false, message);
    }

    public String getSuccessJsonResponse(String language, String message) {
        return this.getResponse(true, language, message);
    }

    private String getResponse(boolean success, String message) {
        this.jsonObjectRoot.addProperty(RESPONSE, success ? OK : ERROR);
        this.jsonObjectRoot.addProperty(MESSAGE, message);
        return this.jsonObjectRoot.toString();
    }

    private String getResponse(boolean success, String language, String message) {
        this.jsonObjectRoot.addProperty(RESPONSE, success ? OK : ERROR);
        this.jsonObjectRoot.addProperty(LANGUAGE, language);
        this.jsonObjectRoot.addProperty(MESSAGE, message);
        return this.jsonObjectRoot.toString();
    }
}

