/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.httpproxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private void forwardRequest(String finalAddress, HttpServletResponse servletResponse) throws Exception {
        Header[] headers;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(finalAddress);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        servletResponse.setStatus(response.getStatusLine().getStatusCode());
        for (Header header : headers = response.getAllHeaders()) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            this.logger.debug("Header name " + headerName);
            this.logger.debug("Header value " + headerValue);
        }
        HttpEntity responseEntity = response.getEntity();
        this.logger.debug("Entity found");
        InputStream in = responseEntity.getContent();
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF-8");
        this.logger.debug("Printing data");
        servletResponse.setContentType(response.getFirstHeader("Content-Type").getValue());
        PrintWriter out = servletResponse.getWriter();
        out.println(writer.toString());
        writer.close();
        this.logger.debug("Data printed");
        out.close();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.logger.debug("Forwarding request to the final address");
        String path = req.getPathInfo();
        this.logger.debug("Path = " + path);
        if (path != null) {
            StringBuilder finalAddressBuilder = new StringBuilder(path);
            finalAddressBuilder.deleteCharAt(0);
            try {
                if (finalAddressBuilder.indexOf("http//") != 0) {
                    finalAddressBuilder.insert(0, "http://");
                }
                this.setParameters(finalAddressBuilder, req.getParameterMap());
                String finalAddress = finalAddressBuilder.toString();
                this.logger.debug("Final address " + finalAddress);
                this.forwardRequest(finalAddress, resp);
            }
            catch (Exception e) {
                this.logger.error("Unable to serve the request", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        } else {
            resp.setContentType("text/html");
            PrintWriter out = resp.getWriter();
            out.println("<h1>Please set the address</h1>");
        }
    }

    private void setParameters(StringBuilder finalAddressBuilder, Map<String, String[]> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            this.logger.debug("No parameters found");
        } else {
            this.logger.debug("Getting parameters");
            finalAddressBuilder.append("?");
            for (String name : parameters.keySet()) {
                this.logger.debug("Parameter name = " + name);
                String[] values = parameters.get(name);
                if (values != null && values.length > 0) {
                    String value = values[0];
                    this.logger.debug("Value = " + value);
                    finalAddressBuilder.append(name).append("=");
                    finalAddressBuilder.append(value).append("&");
                    continue;
                }
                this.logger.debug("Invalid parameter");
            }
            finalAddressBuilder.deleteCharAt(finalAddressBuilder.length() - 1);
        }
    }

    public static void main(String[] args) throws Exception {
        Header[] headers;
        Logger logger = LoggerFactory.getLogger(ProxyServlet.class);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet("http://www.eng.it");
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        System.out.println("Status = " + response.getStatusLine());
        for (Header header : headers = response.getAllHeaders()) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            logger.debug("Header name " + headerName);
            logger.debug("Header value " + headerValue);
        }
        HttpEntity responseEntity = response.getEntity();
        logger.debug("Entity found");
        InputStream in = responseEntity.getContent();
        List lines = IOUtils.readLines((InputStream)in);
        for (String line : lines) {
            System.out.println(line);
        }
    }
}

