/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.sdmx.datasource.cubemanager.querymanager.impl;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.sdmx.datasource.data.BasicQuery;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.sdmxsource.sdmx.api.model.format.DataQueryFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeManagerQuery
extends BasicQuery
implements DataQueryFormat<CubeManagerQuery> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TableId tableId;
    private String queryStatement;

    public void setTableIdentificator(String tableIdentificator) {
        this.tableId = new TableId(Long.parseLong(tableIdentificator));
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public void generateQuery(CubeManager cubeManager) {
        this.logger.debug("Loading table " + this.tableId);
        this.queryStatement = null;
        Table table = cubeManager.getTable(this.tableId);
        this.logger.debug("Table metadata " + table.getAllMetadata());
        this.queryStatement = this.buildSqlQuery(table);
        this.logger.debug("Query generated");
    }

    private StringBuilder generateQueryFilter() {
        int i;
        this.logger.debug("Generating query filter");
        StringBuilder response = null;
        ArrayList<StringBuilder> expressionsList = new ArrayList<StringBuilder>();
        for (i = 0; i < this.columnParameters.size(); ++i) {
            String columnParameter = (String)this.columnParameters.get(i);
            Object value = this.queryParameters.get(i);
            BasicQuery.OperationType operation = (BasicQuery.OperationType)this.operations.get(i);
            expressionsList.add(this.generateQueryFilterExpression(columnParameter, value, operation));
        }
        if (expressionsList.size() != 0) {
            response = new StringBuilder((CharSequence)expressionsList.get(0));
            for (i = 1; i < expressionsList.size(); ++i) {
                response.append(" AND ").append((CharSequence)expressionsList.get(i));
            }
        } else {
            this.logger.debug("No expressions");
            response = null;
        }
        this.logger.debug("Final expression = " + response);
        return response;
    }

    private StringBuilder generateQueryFilterExpression(String columnParameter, Object queryParameter, BasicQuery.OperationType operation) {
        this.logger.debug("Generating expression for " + columnParameter + " " + operation + " " + queryParameter);
        StringBuilder response = new StringBuilder();
        response.append(columnParameter).append(" ").append(operation.toString()).append(" ").append(queryParameter);
        this.logger.debug("Expression " + response);
        return response;
    }

    private String buildSqlQuery(Table table) {
        List selectColumns = table.getColumns();
        StringBuilder sql = new StringBuilder("SELECT ");
        for (Column selectColumn : selectColumns) {
            this.logger.debug("Adding select column " + selectColumn);
            sql.append(selectColumn).append(", ");
        }
        sql.deleteCharAt(sql.length() - 2);
        sql.append("FROM ").append(table.getName());
        StringBuilder whereClause = this.generateQueryFilter();
        if (whereClause != null) {
            sql.append(" WHERE ").append((CharSequence)whereClause);
        }
        this.logger.debug("Statement " + sql);
        return sql.toString();
    }

    public String getStatement() {
        return this.queryStatement;
    }
}

