package org.gcube.data.analysis.statisticalmanager.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDefaultService;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerService;
import org.gcube.data.analysis.statisticalmanager.stubs.ComputationPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.service.ComputationServiceAddressingLocator;




public class StatisticalManagerServicePlugin extends AbstractPlugin<ComputationPortType, StatisticalManagerService> {

	private static final String SERVICE_NAME = "gcube/data/analysis/statisticalmanager/statisticalmanagerfactory";

	public StatisticalManagerServicePlugin() {
		super(SERVICE_NAME);
		
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		// TODO Auto-generated method stub
		fault.printStackTrace();
		return fault;
	}

	@Override
	public ComputationPortType resolve(EndpointReferenceType address,
			ProxyConfig<?, ?> config) throws Exception {
		return new ComputationServiceAddressingLocator().getComputationPortTypePort(address);
	}

	@Override
	public StatisticalManagerService newProxy(
			ProxyDelegate<ComputationPortType> delegate) {
		return new StatisticalManagerDefaultService(delegate);
	}

}
