package org.gcube.data.analysis.statisticalmanager.proxies;

import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTypeParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMOperation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMOperationInfo;


public interface StatisticalManagerFactory {
	
	SMListGroupedAlgorithms getAlgorithms(SMTypeParameter... typeParameters);
	
	SMListGroupedAlgorithms getAlgorithmsUser(SMTypeParameter... typeParameters);

	SMParameters getAlgorithmParameters(String algorithm); 

	SMOperationInfo getComputationInfo(String computationId, String user);
	
	SMComputation getComputation(String computationId);
	
	void removeComputation(String computationId);
	
	SMComputations getComputations(String user,
			SMTypeParameter... typeParameters);
	
	String executeComputation(SMComputationRequest requestComputation);
	
	String resubmitComputation(String computationId);
				

}
