/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.sf.csv4j.CSVFileProcessor;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVLineProcessorGeneric;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVLineProcessorTimeSeries;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class CSVImporter {
    private static GCUBELog logger = new GCUBELog(CSVImporter.class);
    private File file;
    private boolean hasHeader;
    private String tableLabel;
    private String tableTemplate;
    private String delimiter;
    private char comment;

    public CSVImporter(File file, boolean hasHeader, String tableLabel, String tableTemplate, String delimiter, String comment) {
        this.file = file;
        this.hasHeader = hasHeader;
        this.tableLabel = tableLabel;
        this.tableTemplate = tableTemplate;
        this.delimiter = delimiter;
        this.comment = comment != null && !comment.isEmpty() ? comment.charAt(0) : (char)35;
    }

    public String toTabularData() throws Exception {
        Connection conn = null;
        PreparedStatement createTable = null;
        String dbTableName = null;
        try {
            try {
                conn = DriverManager.getConnection(DataBaseManager.getUrlDB(), DataBaseManager.getUsername(), DataBaseManager.getPassword());
                conn.setAutoCommit(false);
                dbTableName = String.valueOf(this.tableTemplate) + "_ID" + UUID.randomUUID().toString().replace("-", "_");
                dbTableName = dbTableName.toLowerCase();
                String sql = null;
                sql = this.tableTemplate.equals(TableTemplates.GENERIC.toString()) ? this.getSqlStatmentCreateGeneric(dbTableName) : (this.tableTemplate.equals(TableTemplates.TIMESERIES.toString()) ? this.getSqlStatmentCreateTimeSeries(dbTableName) : String.format("create table %s (like %s)", dbTableName, this.tableTemplate));
                logger.debug((Object)("SQL create table: " + sql));
                System.out.println("SQL create table: " + sql);
                createTable = conn.prepareStatement(sql);
                createTable.executeUpdate();
                logger.debug((Object)("SQL string " + String.format("COPY %s FROM STDIN WITH DELIMITER '%s' %s  QUOTE '\"' ESCAPE '\\\\' ", dbTableName, this.delimiter, this.hasHeader ? "CSV HEADER" : "CSV")));
                CopyManager copyManager = new CopyManager((BaseConnection)conn);
                copyManager.copyIn(String.format("COPY %s FROM STDIN WITH DELIMITER '%s' %s QUOTE '\"' ESCAPE '\\\\' ", dbTableName, this.delimiter, this.hasHeader ? "CSV HEADER" : "CSV"), (InputStream)new FileInputStream(this.file));
                conn.commit();
            }
            catch (Exception e) {
                logger.error((Object)"CSV importer error :", (Throwable)e);
                DataBaseManager.rollback(conn);
                throw new Exception();
            }
        }
        catch (Throwable throwable) {
            DataBaseManager.closeStatement(createTable);
            DataBaseManager.closeConn(conn);
            throw throwable;
        }
        DataBaseManager.closeStatement(createTable);
        DataBaseManager.closeConn(conn);
        return dbTableName;
    }

    private String getSqlStatmentCreateGeneric(String dbTableName) throws Exception {
        CSVFileProcessor fp = new CSVFileProcessor();
        CSVLineProcessorGeneric lineProcessor = new CSVLineProcessorGeneric(this.delimiter);
        fp.setHasHeader(this.hasHeader);
        fp.setComment(this.comment);
        try {
            try {
                fp.processFile(this.file.getAbsolutePath(), (CSVLineProcessor)lineProcessor);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                logger.debug((Object)"file finished before counted");
            }
        }
        catch (Throwable throwable) {}
        logger.debug((Object)("hasHeader " + this.hasHeader));
        logger.debug((Object)("comment" + this.comment));
        ArrayList<String> sqltypes = new ArrayList<String>();
        logger.debug((Object)("Size column" + lineProcessor.firstColumns.size()));
        for (ArrayList<String> column : lineProcessor.firstColumns) {
            logger.debug((Object)"Print conlumn");
            this.printArray(column);
            sqltypes.add(CSVLineProcessorGeneric.getSqlType(column));
            logger.debug((Object)"add type ");
        }
        lineProcessor.addSqlType(sqltypes);
        List<String> cols = lineProcessor.getColsName();
        logger.debug((Object)("cols.size:" + cols.size()));
        logger.debug((Object)("addSqlType.size:" + lineProcessor.getSqlType().size()));
        logger.debug((Object)"Types:");
        this.printArray(lineProcessor.getSqlType());
        String args = "";
        int i = 0;
        for (String colName : cols) {
            args = i >= lineProcessor.getSqlType().size() ? String.valueOf(args) + String.format("%s %s,", colName, "varchar") : String.valueOf(args) + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
            logger.debug((Object)("args" + args));
        }
        String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
        return sql;
    }

    private String getSqlStatmentCreateTimeSeries(String dbTableName) throws Exception {
        CSVFileProcessor fp = new CSVFileProcessor();
        CSVLineProcessorTimeSeries lineProcessor = new CSVLineProcessorTimeSeries(this.delimiter);
        fp.setHasHeader(this.hasHeader);
        fp.setComment(this.comment);
        try {
            fp.processFile(this.file.getAbsolutePath(), (CSVLineProcessor)lineProcessor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!lineProcessor.isTimeFound()) {
            throw new Exception();
        }
        this.file = lineProcessor.getFile();
        logger.debug((Object)("hasHeader " + this.hasHeader));
        logger.debug((Object)("comment" + this.comment));
        List<String> cols = lineProcessor.getColsName();
        String args = "";
        int i = 0;
        for (String colName : cols) {
            args = i >= lineProcessor.getSqlType().size() ? String.valueOf(args) + String.format("%s %s,", colName, "varchar") : String.valueOf(args) + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
            logger.debug((Object)("args" + args));
        }
        String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
        return sql;
    }

    private void printArray(List<String> a) {
        logger.debug((Object)a.toString());
    }
}

