/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace.genericresources;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;

public class GenericRGenerator {
    public static final String SECONDARY_TYPE = "StatisticalManagerAlgorithm";
    private static int call = 0;
    private static Lock l = new ReentrantLock();
    GCUBELog logger = new GCUBELog(ComputationFactory.class);
    public static int consecutiveCall = 0;
    private static ArrayList<String> algoritmJustPublish = new ArrayList();

    protected StringBuilder createGR(SMAlgorithm a, String name, String description, List<StatisticalType> parameters) throws Exception {
        StringBuilder xml = new StringBuilder();
        ArrayList<SMParameter> listParameters = new ArrayList<SMParameter>();
        xml.append("<Resource version=\"0.4.x\">");
        xml.append("<Type>GenericResource</Type>");
        xml.append("<Profile>");
        xml.append("<SecondaryType>");
        xml.append(SECONDARY_TYPE);
        xml.append("</SecondaryType>");
        xml.append("<Name>");
        xml.append(name);
        xml.append("</Name>");
        xml.append("<Description>");
        xml.append(description);
        xml.append("</Description>");
        xml.append("<Body>");
        xml.append("<category>");
        xml.append(a.getCategory());
        xml.append("</category>");
        for (StatisticalType param : parameters) {
            SMParameter smParameter = FactoryComputationParameter.createParameter(param);
            if (smParameter == null) continue;
            listParameters.add(smParameter);
        }
        SMParameters smParameters = new SMParameters(listParameters.toArray(new SMParameter[listParameters.size()]));
        xml.append("<inputs>");
        SMParameter[] sMParameterArray = smParameters.getList();
        int n = sMParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            SMParameter smParam = sMParameterArray[n2];
            xml.append("<input><name>" + smParam.getName() + "</name>" + "<description>" + smParam.getDescription() + "</description>" + "<defaultValue>" + smParam.getDefaultValue() + "</defaultValue>" + "<type>" + smParam.getType().getName() + "</type>" + "</input>");
            ++n2;
        }
        xml.append("</inputs>");
        xml.append("</Body>");
        xml.append("</Profile>");
        xml.append("</Resource>");
        return xml;
    }

    public List<String> getGenericResources() throws Exception {
        ArrayList<String> algNames = new ArrayList<String>();
        GCUBEScope[] gCUBEScopeArray = ServiceContext.getContext().getStartScopes();
        int n = gCUBEScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GCUBEScope s = gCUBEScopeArray[n2];
            ScopeProvider.instance.set(s.toString());
            String queryString = "for $resource in collection('/db/Profiles/GenericResource')//Resource where ($resource/Profile/SecondaryType eq 'StatisticalManagerAlgorithm') and ($resource/Scopes/Scope eq '" + s.toString() + "') return $resource/Profile/Name/text()";
            this.logger.debug((Object)queryString);
            QueryBox q = new QueryBox(queryString);
            DiscoveryClient client = ICFactory.client();
            algNames.addAll(client.submit((Query)q));
            ++n2;
        }
        algoritmJustPublish = new ArrayList();
        algoritmJustPublish.addAll(algNames);
        int size = algNames.size();
        this.logger.debug((Object)("Size gr found :" + size));
        return algNames;
    }

    public boolean isPublished(String name) throws Exception {
        ArrayList algNames = new ArrayList();
        GCUBEScope[] gCUBEScopeArray = ServiceContext.getContext().getStartScopes();
        int n = gCUBEScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GCUBEScope s = gCUBEScopeArray[n2];
            ScopeProvider.instance.set(s.toString());
            String queryString = "for $resource in collection('/db/Profiles/GenericResource')//Resource where (resource/Profile/Name/text() eq '" + name + "')" + " and ($resource/Scopes/Scope eq '" + s.toString() + "') return $resource/Profile/Name/text()";
            QueryBox q = new QueryBox(queryString);
            DiscoveryClient client = ICFactory.client();
            if (client.submit((Query)q).size() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean existGR(List<String> listExistAlg, String name) throws Exception {
        for (String algName : listExistAlg) {
            if (!name.equals(algName)) continue;
            return true;
        }
        return false;
    }

    public void publishGRNew(HashMap<SMAlgorithm, List<StatisticalType>> algorithms) throws Exception {
        ArrayList<String> listExistAlg = new ArrayList();
        listExistAlg = this.getGenericResources();
        HashMap<String, String> algJustPublish = new HashMap<String, String>();
        if (++consecutiveCall == 1) {
            for (Map.Entry<SMAlgorithm, List<StatisticalType>> alg : algorithms.entrySet()) {
                List<StatisticalType> parameters = alg.getValue();
                SMAlgorithm a = alg.getKey();
                String name = alg.getKey().getName();
                this.logger.debug((Object)("Algorithm :" + name));
                algJustPublish.put(name, name);
                String description = alg.getKey().getDescription();
                if (this.existGR(listExistAlg, name)) continue;
                this.logger.debug((Object)("Create resource." + name));
                StringBuilder xml = this.createGR(a, name, description, parameters);
                String xmlResource = xml.toString();
                StringReader reader = new StringReader(xmlResource);
                GenericResource resource = (GenericResource)Resources.unmarshal(GenericResource.class, (Reader)reader);
                ArrayList<String> scopes = new ArrayList<String>();
                GCUBEScope[] gCUBEScopeArray = ServiceContext.getContext().getStartScopes();
                int n = gCUBEScopeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GCUBEScope s = gCUBEScopeArray[n2];
                    GCUBEScope.Type type = s.getType();
                    String scope = s.toString();
                    if (type == GCUBEScope.Type.VO) {
                        scopes.add(scope);
                    }
                    ++n2;
                }
                this.logger.debug((Object)"Publish");
                ScopedPublisher sp = RegistryPublisherFactory.scopedPublisher();
                Resource resource2 = sp.create((Resource)resource, scopes);
            }
        }
        if (consecutiveCall >= 3) {
            consecutiveCall = 0;
        }
    }
}

