/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence.algorithms;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.statisticalmanager.experimentspace.AlgorithmCategory;
import org.gcube.data.analysis.statisticalmanager.persistence.algorithms.AlgorithmDescriptor;

public class AlgorithmCategoryDescriptor {
    private AlgorithmCategory category;
    private Map<String, AlgorithmDescriptor> algorithms;

    public AlgorithmCategoryDescriptor(AlgorithmCategory category, Collection<AlgorithmDescriptor> algorithms) {
        this.category = category;
        this.algorithms = new HashMap<String, AlgorithmDescriptor>();
        for (AlgorithmDescriptor desc : algorithms) {
            this.algorithms.put(desc.getName(), desc);
        }
    }

    public Map<String, AlgorithmDescriptor> getAlgorithms() {
        return this.algorithms;
    }

    public AlgorithmCategory getCategory() {
        return this.category;
    }

    public boolean containsAlgorithm(String algorithmName) {
        return this.algorithms.containsKey(algorithmName);
    }

    public AlgorithmDescriptor getAlgorithmDescriptor(String algorithmName) {
        return this.algorithms.get(algorithmName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlgorithmCategoryDescriptor other = (AlgorithmCategoryDescriptor)obj;
        return this.category == other.category;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AlgorithmCategoryDescriptor [category=");
        builder.append((Object)this.category);
        builder.append(", algorithms=");
        builder.append(this.algorithms);
        builder.append("]");
        return builder.toString();
    }
}

