/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.data.connection;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.gcube.common.database.endpoint.DatabaseEndpoint;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.postgresql.PGConnection;

public class Tomcat7DatabaseConnectionProvider
implements DatabaseConnectionProvider {
    private static final String DRIVER = "org.postgresql.Driver";
    private DatabaseEndpoint databaseEndpoint;
    private DataSource dataSource;

    public Tomcat7DatabaseConnectionProvider(DatabaseEndpoint databaseEndpoint) {
        this.databaseEndpoint = databaseEndpoint;
        this.initializeDatasource();
    }

    private void initializeDatasource() {
        PoolProperties poolConfiguration = this.buildPoolConfiguration();
        this.dataSource = new DataSource();
        this.dataSource.setPoolProperties((PoolConfiguration)poolConfiguration);
    }

    private PoolProperties buildPoolConfiguration() {
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setUrl(this.getConnectionString());
        poolProperties.setDriverClassName(DRIVER);
        poolProperties.setUsername(this.getDBUsername());
        poolProperties.setPassword(this.getDBPassword());
        return poolProperties;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public PGConnection getPostgreSQLConnection() throws SQLException {
        return this.dataSource.getConnection().unwrap(PGConnection.class);
    }

    @Override
    public DatabaseEndpoint getDatabaseEndpoint() {
        return this.databaseEndpoint;
    }

    private String getConnectionString() {
        return this.databaseEndpoint.getConnectionString();
    }

    private String getDBUsername() {
        return this.databaseEndpoint.getCredentials().getUsername();
    }

    private String getDBPassword() {
        return this.databaseEndpoint.getCredentials().getPassword();
    }
}

