package org.gcube.data.analysis.tabulardata.cube.data;

import org.gcube.data.analysis.tabulardata.model.datatype.DataType;

/**
 * Database Wrangler offers methods for managing relational tables on a DB:
 * - Creation of tables
 * - Removal of tables
 * 
 * @author "Luigi Fortunati"
 *
 */
public interface DatabaseWrangler {
	
	public String createTable();
	
	public String createTable(boolean unsafe);
	
	public void removeTable(String tableName);
	
	public String cloneTable(String tableName, boolean withData, boolean unsafe);
	
	public void addColumn(String tableName, String columnName, DataType type);
	
	public void removeColumn(String tableName, String columnName);
	
	public void createIndex(String tableName, String columnName);

}
