package org.gcube.data.analysis.tabulardata.cube.data;

import org.gcube.data.analysis.tabulardata.model.datatype.DataType;

/**
 * Database Wrangler offers methods for managing relational tables on a DB:
 * - Creation of tables
 * - Removal of tables
 * 
 * @author "Luigi Fortunati"
 *
 */
public interface DatabaseWrangler {
	
	/**
	 * 
	 * @return the name of the created table
	 */
	public String createTable();
	
	/**
	 * 
	 * @param unsafe a boolean telling if the table can should be unsafe or not (tradeoff performance/reliability)
	 * @return the name of the created table
	 */
	public String createTable(boolean unsafe);
	
	public void removeTable(String tableName);
	
	/**
	 * 
	 * @param tableName
	 * @param withData
	 * @param unsafe
	 * @return the name of the created table
	 */
	public String cloneTable(String tableName, boolean withData, boolean unsafe);
	
	public void addColumn(String tableName, String columnName, DataType type);
	
	public void removeColumn(String tableName, String columnName);
	
	public void alterColumnType(String tableName, String columnName, DataType newType);
	
	public void createIndex(String tableName, String columnName);
	
	public void setNullable(String tableName, String columnName, boolean nullable);
	
	public void createUniqueIndex(String tableName, String columnName);
	
	public void createInsertUpdateTriggerOnTable(String triggerName, String targetTableName, String procedureName);

}
