CREATE OR REPLACE FUNCTION normalize_quarter(quarter text) RETURNS text as $$
	DECLARE
		tmp_day text;
		tmp_year text;
	BEGIN
		tmp_year := substring(quarter FROM '^([0-9]{1,4})-Q[1-4]$');
		tmp_day := tmp_year || '-01-01';
		tmp_day := normalize_day(tmp_day);
		return substring(tmp_day FROM '^[0-9]{4}') || substring(quarter FROM '(-Q[1-4])$');		
	END
$$ LANGUAGE plpgsql;