/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.data.connection;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.gcube.common.database.DatabaseEndpointIdentifier;
import org.gcube.common.database.DatabaseProvider;
import org.gcube.common.database.endpoint.DatabaseEndpoint;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.postgresql.PGConnection;

public class Tomcat7DatabaseConnectionProvider
implements DatabaseConnectionProvider {
    private static final String DRIVER = "org.postgresql.Driver";
    private DataSource dataSource = null;
    private DatabaseProvider databaseProvider;
    private DatabaseEndpointIdentifier endpointIdentifier;
    boolean initialized = false;

    public Tomcat7DatabaseConnectionProvider(DatabaseProvider databaseProvider, DatabaseEndpointIdentifier endpointIdentifier) {
        this.databaseProvider = databaseProvider;
        this.endpointIdentifier = endpointIdentifier;
    }

    private void initializeDatasource() {
        PoolProperties poolConfiguration = this.buildPoolConfiguration();
        this.dataSource = new DataSource();
        this.dataSource.setPoolProperties((PoolConfiguration)poolConfiguration);
        this.initialized = true;
    }

    private PoolProperties buildPoolConfiguration() {
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setUrl(this.getConnectionString());
        poolProperties.setDriverClassName(DRIVER);
        poolProperties.setUsername(this.getDBUsername());
        poolProperties.setPassword(this.getDBPassword());
        return poolProperties;
    }

    public Connection getConnection() throws SQLException {
        this.initializeDatasourceIfNotInitialized();
        return this.dataSource.getConnection();
    }

    private void initializeDatasourceIfNotInitialized() {
        if (!this.initialized) {
            this.initializeDatasource();
        }
    }

    public PGConnection getPostgreSQLConnection() throws SQLException {
        this.initializeDatasourceIfNotInitialized();
        return this.dataSource.getConnection().unwrap(PGConnection.class);
    }

    public DatabaseEndpoint getDatabaseEndpoint() {
        return this.databaseProvider.get(this.endpointIdentifier);
    }

    private String getConnectionString() {
        return this.getDatabaseEndpoint().getConnectionString();
    }

    private String getDBUsername() {
        return this.getDatabaseEndpoint().getCredentials().getUsername();
    }

    private String getDBPassword() {
        return this.getDatabaseEndpoint().getCredentials().getPassword();
    }
}

